% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.jumpRegression-method}
\alias{predict,est.jumpRegression-method}
\title{Prediction for a regression model dependent on a Poisson process}
\usage{
\S4method{predict}{est.jumpRegression}(object, t, only.interval = TRUE,
  level = 0.05, burnIn, thinning, Lambda.mat, fun.mat,
  which.series = c("new", "current"), M2pred = 10, cand.length = 1000,
  pred.alg = c("Distribution", "simpleTrajectory", "simpleBayesTrajectory"),
  sample.length, grid = 1e-05, plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.jumpRegression", created with method \code{\link{estimate,jumpRegression-method}}}

\item{t}{vector of time points to make predictions for}

\item{only.interval}{if TRUE: only calculation of prediction intervals}

\item{level}{level of the prediction intervals}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{Lambda.mat}{matrix-wise definition of intensity rate function (makes it faster)}

\item{fun.mat}{matrix-wise definition of regression function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector"), for jump diffusion}

\item{pred.alg}{prediction algorithm, "Distribution", "Trajectory", "simpleTrajectory" or "simpleTrajectory"}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{grid}{fineness degree of sampling approximation}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of a regression model
  \eqn{y_i = f(t_i, N_{t_i}, \theta) + \epsilon_i} with
  \eqn{N_t\sim Pois(\Lambda(t, \xi)), \epsilon_i\sim N(0,\gamma^2\widetilde{s}(t))}.
}
\examples{
t <- seq(0,1, by = 0.01)
cl <- set.to.class("jumpRegression", fun = function(t, N, theta) theta[1]*t + theta[2]*N,
             parameter = list(theta = c(1,2), gamma2 = 0.1, xi = c(3, 1/4)),
             Lambda = function(t, xi) (t/xi[2])^xi[1])
data <- simulate(cl, t = t)
est <- estimate(cl, t, data, 1000)
plot(est)
\dontrun{
pred <- predict(est, Lambda.mat = function(t, xi) (t/xi[,2])^xi[,1],
                 fun.mat = function(t, N, theta) theta[,1]*t + theta[,2]*N)
}
pred <- predict(est, pred.alg = "simpleTrajectory", sample.length = 100)
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

