% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,est.jumpDiffusion-method}
\alias{predict,est.jumpDiffusion-method}
\title{Prediction for a jump diffusion process}
\usage{
\S4method{predict}{est.jumpDiffusion}(object, t, burnIn, thinning, Lambda.mat,
  which.series = c("new", "current"), M2pred = 10, cand.length = 1000,
  pred.alg = c("Trajectory", "Distribution", "simpleTrajectory",
  "simpleBayesTrajectory"), pred.alg.N = c("Trajectory", "Distribution"),
  candN = 0:5, sample.length, plot.prediction = TRUE)
}
\arguments{
\item{object}{class object of MCMC samples: "est.jumpDiffusion", created with method \code{\link{estimate,jumpDiffusion-method}}}

\item{t}{vector of time points to make predictions for}

\item{burnIn}{burn-in period}

\item{thinning}{thinning rate}

\item{Lambda.mat}{matrix-wise definition of intensity rate function (makes it faster)}

\item{which.series}{which series to be predicted, new one ("new") or further development of current one ("current")}

\item{M2pred}{optional, if current series to be predicted and t missing, \code{M2pred} variables will be predicted
with the observation time distances}

\item{cand.length}{length of candidate samples (if method = "vector"), for jump diffusion}

\item{pred.alg}{prediction algorithm, "Distribution", "Trajectory", "simpleTrajectory" or "simpleBayesTrajectory"}

\item{pred.alg.N}{prediction algorithm, "Distribution", "Trajectory"}

\item{candN}{vector of candidate area for differences of N, only if pred.alg.N = "Distribution"}

\item{sample.length}{number of samples to be drawn, default is the number of posterior samples}

\item{plot.prediction}{if TRUE, prediction intervals are plotted}
}
\description{
Bayesian prediction of a stochastic process
  \eqn{dY_t = b(\phi,t,Y_t)dt + s(\gamma,t,Y_t)dW_t + h(\eta,t,Y_t)dN_t}.
}
\examples{
model <- set.to.class("jumpDiffusion",
         parameter = list(theta = 0.1, phi = 0.05, gamma2 = 0.1, xi = c(3, 1/4)),
         Lambda = function(t, xi) (t/xi[2])^xi[1])
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5)
est_jd <- estimate(model, t, data, 2000)
plot(est_jd)
\dontrun{
pred_jd <- predict(est_jd, Lambda.mat = function(t, xi) (t/xi[,2])^xi[,1])
pred_jd2 <- predict(est_jd, pred.alg = "Distribution", pred.alg.N = "Distribution",
                    Lambda.mat = function(t, xi) (t/xi[,2])^xi[,1])
est <- estimate(model, t[1:81], data = list(N = data$N[1:81], Y = data$Y[1:81]), 2000)
pred <- predict(est, t = t[81:101], which.series = "current",
                     Lambda.mat = function(t, xi) (t/xi[,2])^xi[,1])
lines(t, data$Y, type = "l", lwd = 2)
}
pred_jd4 <- predict(est_jd, pred.alg = "simpleTrajectory", sample.length = 100)
for(i in 1:100) lines(t[-1], pred_jd4$Y[i,], col = "grey")
pred_jd5 <- predict(est_jd, pred.alg = "simpleBayesTrajectory", sample.length = 100)
}
\references{
Hermann, S. (2016a). BaPreStoPro: an R Package for Bayesian Prediction of Stochastic Processes.
SFB 823 discussion paper 28/16.

Hermann, S. (2016b). Bayesian Prediction for Stochastic Processes based on the Euler Approximation Scheme.
SFB 823 discussion paper 27/16.
}

