% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,hiddenmixedDiffusion-method}
\alias{estimate,hiddenmixedDiffusion-method}
\title{Estimation for hierarchical (mixed) hidden diffusion process}
\usage{
\S4method{estimate}{hiddenmixedDiffusion}(model.class, t, data, nMCMC, propSd,
  adapt = TRUE, proposal = c("normal", "lognormal"), Npart = 100)
}
\arguments{
\item{model.class}{class of the hierarchical hidden diffusion model including all required information, see \code{\link{hiddenmixedDiffusion-class}}}

\item{t}{list or vector of time points}

\item{data}{list or matrix of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\phi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}

\item{Npart}{number of particles in the particle Gibbs sampler}
}
\description{
Bayesian estimation of the parameters in the hierarchical model:
  \eqn{Z_{ij} = Y_{t_{ij}} + \epsilon_{ij}, dY_t = b(\phi_j,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t, \phi_j\sim N(\mu, \Omega),
  Y_{t_0}=y_0(\phi, t_0), \epsilon_{ij}\sim N(0,\sigma^2)} with the particle Gibbs sampler.
}
\examples{
mu <- c(5, 1); Omega <- c(0.9, 0.04)
phi <- cbind(rnorm(21, mu[1], sqrt(Omega[1])), rnorm(21, mu[2], sqrt(Omega[2])))
y0.fun <- function(phi, t) phi[2]
model <- set.to.class("hiddenmixedDiffusion", y0.fun = y0.fun,
                 b.fun = function(phi, t, y) phi[1],
                 parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 1, sigma2 = 0.01))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = TRUE)

\dontrun{
est <- estimate(model, t, data$Z[1:20,], 2000)
plot(est)
}
}
\references{
Andrieu, C., A. Doucet and R. Holenstein (2010). Particle Markov Chain Monte Carlo Methods.
Journal of the Royal Statistical Society B 72, pp. 269-342.
}

