% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,Diffusion-method}
\alias{estimate,Diffusion-method}
\title{Estimation for diffusion process}
\usage{
\S4method{estimate}{Diffusion}(model.class, t, data, nMCMC, propSd,
  adapt = TRUE, proposal = c("normal", "lognormal"))
}
\arguments{
\item{model.class}{class of the diffusion process model including all required information, see \code{\link{Diffusion-class}}}

\item{t}{vector of time points}

\item{data}{vector of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\phi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}
}
\description{
Bayesian estimation of the parameters \eqn{\phi} and \eqn{\gamma^2} of the stochastic process
  \eqn{dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t}.
}
\examples{
model <- set.to.class("Diffusion", parameter = list(phi = 0.5, gamma2 = 0.01))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5, plot.series = TRUE)
est_diff <- estimate(model, t, data, 1000)
plot(est_diff)
}
\references{
Hermann, S., K. Ickstadt and C. H. Mueller (2016).
Bayesian Prediction of Crack Growth Based on a Hierarchical Diffusion Model.
Applied Stochastic Models in Business and Industry, DOI: 10.1002/asmb.2175.
}

