% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/helpingFunctions.R
\name{ad.propSd}
\alias{ad.propSd}
\title{Adaptation of proposal standard deviation}
\usage{
ad.propSd(chain, propSd, batch, lower = 0.3, upper = 0.6,
  delta.n = function(n) min(0.05, 1/sqrt(n)))
}
\arguments{
\item{chain}{Markov chain}

\item{propSd}{current proposal standard deviation}

\item{batch}{number of batch (of chain)}

\item{lower}{lower bound}

\item{upper}{upper bound}

\item{delta.n}{function of batch number}
}
\value{
adapted proposal standard deviation
}
\description{
Adaptive MCMC: if acceptance rate of the chain is smaller than \code{lower} or larger than \code{upper},
the proposal standard deviation \code{propSd}=exp(l) is adapted with respect to function \code{delta.n},
that means, the new proposal standard deviation
is equal to exp(l-\code{delta.n(batch)}), respectively exp(l+\code{delta.n(batch)}).
}
\references{
Rosenthal, J. S. (2011). Optimal Proposal Distributions and Adaptive MCMC. In: Handbook of Markov Chain Monte Carlo, pp. 93-112.
}

