% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTtest.R
\name{BTtest}
\alias{BTtest}
\title{Barigozzi & Trapani (2022)  Test}
\usage{
BTtest(X, r_max = 10, alpha = 0.05, BT1 = TRUE)
}
\arguments{
\item{X}{a \eqn{T \times N} numerical \code{matrix} or \code{data.frame} of observations.}

\item{r_max}{the maximum number of factors to consider. Default is 10. Note that chaning \code{r_max} does not alter the test result for any individual \code{r}.}

\item{alpha}{the significance level. Default is 0.05.}

\item{BT1}{logical. If \code{TRUE}, a less conservative eigenvalue rescaling scheme is used. In small samples, \code{BT1 = FALSE} will result in fewer estimated factors. Default is \code{TRUE}.}
}
\value{
A vector with the estimated number of (i) factors with a linear trend (\eqn{r_1}), (ii) zero-mean \eqn{I(1)} factors (\eqn{r_2}) and (ii) zero-mean \eqn{I(0)} factors (\eqn{r_3}).
}
\description{
Runs the testing routine proposed in Barigozzi & Trapani (2022) to estimate the number and types of common trends in a nonstationary panel.
The method can identify the existence of a common factor subject to a linear trend, as well as the number of zero-mean \eqn{I(1)} and zero-mean \eqn{I(0)} factors.
}
\details{
For details on the testing procedure I refer to Barigozzi & Trapani (2022, sec. 4).
}
\examples{
# Simulate a nonstationary panel
X <- sim_DGP(N = 100, n_Periods = 200)

# Obtain the estimated number of factors (i) with a linear trend (r_1), (ii) zero-mean I(1) (r_2)
# and (iii) zero-mean I(0) (r_3)
BTtest(X = X, r_max = 10, alpha = 0.05, BT1 = TRUE)
}
\references{
Barigozzi, M., & Trapani, L. (2022). Testing for common trends in nonstationary large datasets. \emph{Journal of Business & Economic Statistics}, 40(3), 1107-1122. \doi{10.1080/07350015.2021.1901719}
}
\author{
Paul Haimerl
}
