% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bgbb.PosteriorMeanLmProductMoment}
\alias{bgbb.PosteriorMeanLmProductMoment}
\title{BG/BB Posterior Mean (l,m)th Product Moment}
\usage{
bgbb.PosteriorMeanLmProductMoment(params, l, m, x, t.x, n.cal)
}
\arguments{
\item{params}{BG/BB parameters - a vector with alpha, beta, gamma, and delta, in that order. Alpha and beta are unobserved parameters for the beta-Bernoulli transaction process. Gamma and delta are unobserved parameters for the beta-geometric dropout process.}

\item{l}{moment degree of P}

\item{m}{moment degree of Theta}

\item{x}{number of repeat transactions a customer made in the
calibration period, or a vector of calibration period transaction
frequencies.}

\item{t.x}{recency - the last transaction opportunity in which
a customer made a transaction, or a vector of recencies.}

\item{n.cal}{number of transaction opportunities in the
calibration period, or a vector of calibration period transaction
opportunities.}
}
\value{
The expected posterior (\code{l},\code{m})th product moment.
}
\description{
Computes the (\code{l},\code{m})th product moment of the joint
posterior distribution of P (the Bernoulli transaction
process parameter) and Theta (the geometric dropout
process parameter).
}
\details{
E((P)^l(Theta)^m | alpha, beta, gamma, delta, x, t.x, n)

\code{x}, \code{t.x}, and \code{n.cal} may be vectors. The
standard rules for vector operations apply - if they are not of
the same length, shorter vectors will be recycled (start over at
the first element) until they are as long as the longest
vector. It is advisable to keep vectors to the same length and to
use single values for parameters that are to be the same for all
calculations. If one of these parameters has a length greater than
one, the output will be also be a vector.
}
\references{
Fader, Peter S., Bruce G.S. Hardie, and Jen Shang. \dQuote{Customer-Base Analysis in a Discrete-Time Noncontractual Setting.} \emph{Marketing Science} 29(6), pp. 1086-1108. 2010. INFORMS. \url{http://www.brucehardie.com/papers/020/}

See equation 17.
}

