% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSL_model.R
\docType{class}
\name{BSLMODEL-class}
\alias{BSLMODEL-class}
\alias{BSLModel}
\alias{initialize.BSLMODEL}
\alias{validBSLModelObject}
\alias{fn,BSLMODEL-method}
\alias{setns,BSLMODEL-method}
\title{S4 class ``BSLMODEL''}
\usage{
BSLModel(fnSim, fnSimVec, fnSum, fnLogPrior, simArgs, sumArgs, theta0,
  thetaNames, test = TRUE)

initialize.BSLMODEL(.Object, fnSim, fnSimVec, simArgs, fnSum, sumArgs,
  fnLogPrior, theta0, thetaNames, test = TRUE)

validBSLModelObject(object)

\S4method{fn}{BSLMODEL}(.Object)

\S4method{setns}{BSLMODEL}(.Object)
}
\arguments{
\item{fnSim}{A function that simulates data for a given parameter value. The first argument should be the 
parameters. Other necessary arguments (optional) can be specified with \code{simArgs}.}

\item{fnSimVec}{A vectorised function that simulates a number of datasets simultaneously for a given parameter
value. The first two arguments should be the number of simulations to run and parameters, respectively. Other necessary 
arguments (optional) can be specified with \code{simArgs}. The output must be a list of each simulation result.}

\item{fnSum}{A function for computing summary statistics of data. The first argument should be the observed 
or simulated dataset. Other necessary arguments (optional) can be specified with \code{sumArgs}.}

\item{fnLogPrior}{A function that computes the log of prior density for a parameter. If this is missing, the prior 
by default is an improper flat prior over the real line for each parameter. The function must have a single input: a
vector of parameter values.}

\item{simArgs}{A list of additional arguments to pass into the simulation function. Only use when the input 
\code{fnSim} requires additional arguments.}

\item{sumArgs}{A list of additional arguments to pass into the summary statistics function. Only use when the 
input \code{fnSum} requires additional arguments.}

\item{theta0}{Initial guess of the parameter value.}

\item{thetaNames}{A string vector of parameter names, which must have the same length as the parameter vector.}

\item{test}{Logical, whether a short simulation test will be ran upon initialisation.}

\item{.Object}{A ``BSLMODEL'' object.}

\item{object}{A ``BSLMODEL'' object.}
}
\description{
The S4 class contains the simulation and summary statistics function and other necessary arguments
for a model to run in the main \code{bsl} function.

\code{BSLModel} is the constructor function for a \code{BSLMODEL} object.

\code{initialize.BSLMODEL} initialises a ``BSLMODEL'' object.

\code{validBSLModelObject} check the validity of a ``BSLMODEL'' object.
}
\section{Methods (by generic)}{
\itemize{
\item \code{fn}: Generate the generic simulation and summary statistics function for \code{n}
simulations and fixed \code{theta} (for internal use).

\item \code{setns}: Find and set the length of summary statistics with a test run (for internal use).
}}

\section{Slots}{

\describe{
\item{\code{fnSim}}{A function that simulates data for a given parameter value. The first argument should be the
parameters. Other necessary arguments (optional) can be specified with \code{simArgs}.}

\item{\code{fnSimVec}}{A vectorised function that simulates a number of datasets simultaneously for a given parameter
value. If this is not \code{NULL}, vectorised simulation function will be used instead of \code{fnSim}. The
first two arguments should be the number of simulations to run and parameters, respectively. Other necessary 
arguments (optional) can be specified with \code{simArgs}. The output must be a list of each simulation result.}

\item{\code{fnSum}}{A function for computing summary statistics of data. The first argument should be the observed
or simulated dataset. Other necessary arguments (optional) can be specified with \code{sumArgs}. The users
should code this function carefully so the output have fixed length and never contain any \code{Inf} value.}

\item{\code{fnLogPrior}}{A function that computes the log of prior density for a parameter. The default is \code{NULL},
which uses an improper flat prior over the real line for each parameter. The function must have a single input: a
vector of parameter values.}

\item{\code{simArgs}}{A list of additional arguments to pass into the simulation function. Only use when the input
\code{fnSim} or \code{fnSimVec} requires additional arguments. The default is \code{NULL}.}

\item{\code{sumArgs}}{A list of additional arguments to pass into the summary statistics function. Only use when the
input \code{fnSum} requires additional arguments. The default is \code{NULL}.}

\item{\code{theta0}}{Initial guess of the parameter value, which is used as the starting value for MCMC.}

\item{\code{thetaNames}}{Expression, parameter names.}

\item{\code{ns}}{The number of summary statistics of a single observation. Note this will be generated automatically, 
thus is not required for initialisation.}

\item{\code{test}}{Logical indicator of whether a short simulation test will be ran upon initialisation.}
}}

\examples{
data(ma2)
model <- BSLModel(fnSim = ma2_sim, fnSum = ma2_sum, simArgs = ma2$sim_options, theta0 = ma2$start,
                  fnLogPrior = ma2_logPrior)
validObject(model)
}
\Rdversion{1.1}
