% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrained_covariance_functions.R
\name{constrained_adjacency_covariance_function}
\alias{constrained_adjacency_covariance_function}
\title{Construct a constrained covariance matrix from the adjacency matrix}
\usage{
constrained_adjacency_covariance_function(
  adj.matrix,
  type,
  hyperparameters,
  linear.combination,
  linear.constraint = 0
)
}
\arguments{
\item{adj.matrix}{The graph adjacency matrix}

\item{type}{The type of covariance function used. One of "sqexp", "ratquad", "matern" or "matrix". Note: only matern with nu = 5/2 is supported.}

\item{hyperparameters}{A vector containing the covariance function hyperparameters. For the squared exponential and matern, the vector should contain the variance and length scale, for the rational quadratic, the vector should contain the variance, length scale and scaling parameters}

\item{linear.combination}{A matrix which defines the linear combination of the parameter vector lambda = (lambda_1, ..., lambda_N)^T. The linear combination is a vector of coefficients such that linear.combination \%*\% lambda = linear.constraint.}

\item{linear.constraint}{The value the linear constraint takes. Defaults to 0.}
}
\value{
The mean vector and covariance matrix
}
\description{
This function constructs a covariance function from the graph's adjacency
matrix. The covariance function may be squared exponential,
rational quadratic, Matern or the matrix exponential.
It includes a constraint, where a linear combination of the parameters
can be fixed.
}
\examples{
#Construct covariance matrix of Dar es Salaam, Tanzania, using network metric
data(dar.adj.matrix, package = "BSBT") #load dar es salaam adjacency matrix
k <- constrained_adjacency_covariance_function(dar.adj.matrix, type = "sqexp",
       hyperparameters = c(1, 1), rep(1, dim(dar.adj.matrix)[1]), 0)
       #Covariance registered by sum of objects is 0 using rational quadratic function
}
\seealso{
For more information about covariance functions see \url{https://www.cs.toronto.edu/~duvenaud/cookbook/} or \url{http://www.gaussianprocess.org/gpml/chapters/RW4.pdf}
}
