% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brvm-company-nbrank.R
\name{company_nbrank}
\alias{company_nbrank}
\title{BRVM get company rank - Get a ticker rank according to brvm quote}
\usage{
company_nbrank(.company)
}
\arguments{
\item{.company}{The company name}
}
\value{
"character"
}
\description{
This function returns the given company rank from the BRVM stock exchange according to their daily change (variation).
It uses \code{BRVM_company_rank()} to show all copanies rank before filtering the company we give as input
}
\details{
This function will get the rank of one companies listed on the BVRM exchange through the Rich Bourse site.
The function takes as parameter the name of company listed on BRVM
}
\examples{
\donttest{
library(dplyr)
company_nbrank("BICC")
company_nbrank("SNTS")
}

}
\seealso{
\url{https://www.brvm.org/en/cours-actions/0}

\code{BRVM_company_rank()}

Other Data Retrieval: 
\code{\link{BRVM_bySector}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_get1}()},
\code{\link{BRVM_get}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()}

Other BRVM: 
\code{\link{BRVM.index}()},
\code{\link{BRVM_cap}()},
\code{\link{BRVM_company_cap}()},
\code{\link{BRVM_company_rank}()},
\code{\link{BRVM_company_url}()},
\code{\link{BRVM_index_stock}()},
\code{\link{BRVM_index}()},
\code{\link{BRVM_market_activity}()},
\code{\link{BRVM_plot}()},
\code{\link{BRVM_stock_market}()},
\code{\link{BRVM_ticker_desc}()},
\code{\link{BRVM_traded_val}()},
\code{\link{company_cap}()},
\code{\link{company_country}()},
\code{\link{company_sector}()},
\code{\link{company_traded_val}()},
\code{\link{normality_test}()},
\code{\link{stationarity_test}()}
}
\author{
Koffi Frederic SESSIE

Oudouss Diakité Abdoul

Steven P. Sanderson II, MPH
}
\concept{BRVM}
\concept{Data Retrieval}
