% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BRACoD.R
\name{simulate_microbiome_counts}
\alias{simulate_microbiome_counts}
\title{Simulate microbiome counts}
\usage{
simulate_microbiome_counts(
  df,
  n_contributors = 20,
  coeff_contributor = 0,
  min_ab_contributor = -9,
  sd_Y = 1,
  n_reads = 1e+05,
  var_contributor = 5,
  use_uniform = TRUE,
  n_samples_use = NULL,
  corr_value = NULL,
  return_absolute = FALSE,
  seed = NULL
)
}
\arguments{
\item{df}{A dataframe of OTU counts that is a model for data simulation. Samples are rows and bacteria are columns.}

\item{n_contributors}{the number of bacteria that are to contribute to your environmental variable.}

\item{coeff_contributor}{the average of the distribution used to simulate the contribution coefficient.}

\item{min_ab_contributor}{The minimum log relative abundance, averaged across samples, to include a bacteria}

\item{sd_Y}{the standard deviation of the simulated environmental variable}

\item{n_reads}{the number of reads to be simulated per sample}

\item{var_contributor}{If you use a uniform distribution, this is the range of the distribution, with a normal distribution it is the variance used to simulate the contribution coefficient.}

\item{use_uniform}{use a uniform distribution to simulate the contribution coefficient. Alternative is the normal distribution.}

\item{n_samples_use}{number of microbiome samples to simulate. If NULL, uses the same number of samples as in your dataframe}

\item{corr_value}{the bug-bug correlation value you want to include in the simulation}

\item{return_absolute}{returns the abosulte abundance values instead of the simulated microbiome counts}

\item{seed}{random seed for reproducibility}
}
\value{
a list containing 1) the simulated count data 2) the simulated environmental variable and 3) the simulated contribution coefficients
}
\description{
Each bacteria's absolute abundance is simulated from a lognormal distribution.
Then, convert each sample to relative abundance, and simulate sequencing counts
using a multinomial distribution, based on the desired number of reads and the
simulated relative abundances. This also simulates an environmental variable that
is produced by some of the bacteria.
}
