% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codes.R
\name{envelope}
\alias{envelope}
\alias{envelope.BP}
\alias{envelope.GA}
\alias{envelope.IG}
\alias{envelope.RBS}
\alias{envelope.WEI3}
\title{Envelopes}
\usage{
envelope(
  model,
  k = 100,
  color = "grey50",
  xlabel = "Theorical Quantile",
  ylabel = "Empirical Quantile",
  font = "serif"
)
}
\arguments{
\item{model}{object of class \code{gamlss}.}

\item{k}{number of replications for envelope construction. Default is 19.}

\item{color}{a specification for the default envelope color.}

\item{xlabel}{a label for the x axis.}

\item{ylabel}{a label for the y axis.}

\item{font}{the name of a font family for x and y axis.}
}
\value{
A simulated envelope.
}
\description{
Computes simulation envelopes.
}
\references{
Atkinson, A.C. Plots, transformations and regression : an introduction to
graphical methods of diagnostic regression analysis. Oxford: Oxford Science
Publications, 1985.

Bourguignon, M., Santos-Neto, M. and Castro, M. A new regression model for
positive random variables with skewed and long tail. \emph{METRON}, v. 79,
p. 33--55, 2021. \doi{http://dx.doi.org/10.1007/s40300-021-00203-y}

Leiva, V., Santos-Neto, M., Cysneiros, F.J.A, Barros, M. Birnbaum-Saunders
statistical modeling: a new approach. \emph{Statistical Modelling},
v. 14, p. 21--48, 2014.
\doi{https://doi.org/10.1177/1471082X13494532}

Santos-Neto, M., Cysneiros, F.J.A., Leiva, V., Barros, M. Reparameterized
Birnbaum-Saunders
regression models with varying precision.
\emph{Electronic Journal of Statistics}, v. 10, p. 2825--2855, 2016.
\doi{https://doi.org/10.1214/16-EJS1187}.
}
\author{
Manoel Santos-Neto \email{manoel.ferreira at professor.ufcg.edu.br}
}
