% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_conmediation.R
\name{bnpconmediation}
\alias{bnpconmediation}
\title{Posterior Means and 95\% C.I.s of the conditional NIE, NDE and TE}
\usage{
bnpconmediation(dataTreatment, dataControl, prior, mcmc, state, status = TRUE,
  na.action, q = 2, NN = 10, n1 = 10, n0 = 10, extra.thin = 0,
  cond.values = c(45, 35), col.values = c(1, 2), seed = 12345)
}
\arguments{
\item{dataTreatment}{The observed data under Z=1}

\item{dataControl}{The observed data under Z=0}

\item{prior}{a list giving the prior information}

\item{mcmc}{a list giving the MCMC parameters}

\item{state}{a list giving the current value of the parameters}

\item{status}{a logical variable indicating whether this run is new (TRUE) or the continuation of a previous analysis (FALSE)}

\item{na.action}{a function that indicates what should happen when the data contain NAs}

\item{q}{A dimension of the observed data, i.e., number of covariates plus 2}

\item{NN}{Number of samples drawn for each iteration from the joint distribution of the mediator and the covariates. Default is 100.}

\item{n1}{Number of observations under Z=1}

\item{n0}{Number of observations under Z=0}

\item{extra.thin}{Giving the extra thinning interval}

\item{cond.values}{conditional values of the covariates}

\item{col.values}{columns orders of the conditional covariates among all covariates}

\item{seed}{Value to be given to the seed}
}
\value{
ENIE Posterior mean of the Natural Indirect Effect (NIE)

ENDE Posterior mean of the Natural Direct Effect (NDE)

ETE Posterior mean of the Total Effect (TE)

IE.c.i 95\% C.I. of the NIE

DE.c.i 95\% C.I. of the NDE

TE.c.i 95\% C.I. of the TE

Y11 Posterior samples of Y11

Y00 Posterior samples of Y00

Y10 Posterior samples of Y10
}
\description{
Obtain posterior means and credible intervals of the effects.
}
