% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMTfit.mme.R
\name{BMTfit.mme}
\alias{BMTfit.mme}
\title{Moment Matching Fit of the BMT Distribution to Non-censored Data.}
\source{
Based on the function \code{\link{mmedist}} of the R package: 
 \code{\link{fitdistrplus}}
 
 Delignette-Muller ML and Dutang C (2015), \emph{fitdistrplus: An R Package 
 for Fitting Distributions}. Journal of Statistical Software, 64(4), 1-34.
}
\usage{
BMTfit.mme(data, start = list(p3 = 0.5, p4 = 0.5, p1 = min(data) - 0.1, p2 =
  max(data) + 0.1), fix.arg = NULL, type.p.3.4 = "t w",
  type.p.1.2 = "c-d", optim.method = "Nelder-Mead", custom.optim = NULL,
  silent = TRUE, ...)
}
\arguments{
\item{data}{A numeric vector with the observed values for non-censored data.}

\item{start}{A named list giving the initial values of parameters of the BMT 
distribution or a function of data computing initial values and returning a 
named list. (see the 'details' section of 
\code{\link{mledist}}).}

\item{fix.arg}{An optional named list giving the values of fixed parameters of
the BMT distribution or a function of data computing (fixed) parameter 
values and returning a named list. Parameters with fixed value are thus NOT 
estimated. (see the 'details' section of 
\code{\link{mledist}}).}

\item{type.p.3.4}{Type of parametrization asociated to p3 and p4. "t w" means 
tails weights parametrization (default) and "a-s" means asymmetry-steepness 
parametrization.}

\item{type.p.1.2}{Type of parametrization asociated to p1 and p2. "c-d" means 
domain parametrization (default) and "l-s" means location-scale 
parametrization.}

\item{optim.method}{\code{"default"} (see the 'details' section of 
\code{\link{mledist}}) or optimization method to pass to 
\code{\link{optim}}.}

\item{custom.optim}{A function carrying the optimization (see the 'details' 
section of \code{\link{mledist}}).}

\item{silent}{A logical to remove or show warnings when bootstraping.}

\item{\dots}{Further arguments to be passed to generic functions or to the 
function \code{"mmedist"}. See \code{\link{mmedist}} for details.}
}
\value{
\code{BMTfit.mme} returns a list with following components,
 
 \item{estimate}{ the parameter estimates.}
 
 \item{convergence}{ an integer code for the convergence of 
 \code{\link{optim}}/\code{\link{constrOptim}} defined as below or defined by
 the user in the user-supplied optimization function.
 
 \code{0} indicates successful convergence.
 
 \code{1} indicates that the iteration limit of \code{\link{optim}} has been 
 reached.
 
 \code{10} indicates degeneracy of the Nealder-Mead simplex.
 
 \code{100} indicates that \code{\link{optim}} encountered an internal error.
 }
 
 \item{value}{the value of the corresponding objective function of the 
 estimation method at the estimate.}
 
 \item{hessian}{a symmetric matrix computed by \code{\link{optim}} as an 
 estimate of the Hessian at the solution found or computed in the 
 user-supplied optimization function.}
 
 \item{loglik}{the log-likelihood value.}
 
 \item{order}{the vector of moment(s) matched: mean (1), standard deviation 
 (2), Pearson's skewness (3), Pearson's kurtosis (4).}
 
 \item{memp}{the empirical moment function. }
 
 \item{optim.function}{the name of the optimization function used for maximum
 product of spacing.}
 
 \item{optim.method}{when \code{\link{optim}} is used, the name of the 
 algorithm used, \code{NULL} otherwise.}
 
 \item{fix.arg}{the named list giving the values of parameters of the named 
 distribution that must kept fixed rather than estimated or \code{NULL} if 
 there are no such parameters. }
 
 \item{fix.arg.fun}{the function used to set the value of \code{fix.arg} or 
 \code{NULL}.}
 
 \item{weights}{the vector of weigths used in the estimation process or 
 \code{NULL}.}
 
 \item{counts}{A two-element integer vector giving the number of calls to the
 log-likelihood function and its gradient respectively. This excludes those 
 calls needed to compute the Hessian, if requested, and any calls to 
 log-likelihood function to compute a finite-difference approximation to the 
 gradient. \code{counts} is returned by \code{\link{optim}} or the 
 user-supplied function or set to \code{NULL}.}
 
 \item{optim.message}{A character string giving any additional information 
 returned by the optimizer, or \code{NULL}. To understand exactly the 
 message, see the source code.}
}
\description{
Fit of the BMT distribution to non-censored data by moment 
 matching (mme).
}
\details{
This function is not intended to be called directly but is internally
 called in \code{\link{BMTfit}} when used with the moment matching method.
 
 \code{BMTfit.mme} is based on the function \code{\link{mmedist}} but it 
 focuses on the moment matching parameter estimation for the BMT distribution
 (see \code{\link{BMT}} for details about the BMT distribution and 
 \code{\link{mmedist}} for details about moment matching fit of univariate 
 distributions).
 
 For each parameter of the BMT distribution we choose a moment or measure. 
 Mean for \code{p1}, standard deviation for \code{p2}, Pearson_s skewness for
 \code{p3}, and Pearson's kurtosis for \code{p4}.
}
\examples{
# (1) basic fit by moment matching estimation
set.seed(1234)
x1 <- rBMT(n=100, p3=0.25, p4=0.75)
BMTfit.mme(x1)

# (3) how to change the optimisation method?
BMTfit.mme(x1, optim.method="L-BFGS-B") 
BMTfit.mme(x1, custom.optim="nlminb")

# (4) estimation of the tails weights parameters of the BMT 
# distribution with domain fixed at [0,1]
BMTfit.mme(x1, start=list(p3=0.5, p4=0.5), fix.arg=list(p1=0, p2=1))

# (5) estimation of the asymmetry-steepness parameters of the BMT 
# distribution with domain fixed at [0,1]
BMTfit.mme(x1, start=list(p3=0, p4=0.5), type.p.3.4 = "a-s", 
           fix.arg=list(p1=0, p2=1))

}
\references{
Torres-Jimenez, C. J. (2017, September), \emph{Comparison of estimation
 methods for the BMT distribution}. ArXiv e-prints.
 
 Torres-Jimenez, C. J. (2018), \emph{The BMT Item Response Theory model: A 
 new skewed distribution family with bounded domain and an IRT model based on
 it}, PhD thesis, Doctorado en ciencias - Estadistica, Universidad Nacional 
 de Colombia, Sede Bogota.
}
\seealso{
See \code{\link{BMT}} for the BMT density, distribution, quantile 
 function and random deviates. See \code{\link{BMTfit.qme}}, 
 \code{\link{BMTfit.mle}}, \code{\link{BMTfit.mge}}, 
 \code{\link{BMTfit.mpse}} and \code{\link{BMTfit.mqde}} for other estimation
 methods. See \code{\link{optim}} and \code{\link{constrOptim}} for 
 optimization routines. See \code{\link{BMTfit}} and \code{\link{fitdist}} 
 for functions that return an objetc of class \code{"fitdist"}.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co}
}
\keyword{distribution}
