% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookups.R
\name{change_parameter_name}
\alias{change_parameter_name}
\title{Convert a parameter name to a different format}
\usage{
change_parameter_name(
  parameter,
  from = c("argument", "url"),
  to = c("url", "argument")
)
}
\arguments{
\item{parameter}{character; name of the parameter provided to the relevant \code{build()} function}

\item{from}{character; one of "argument" or "url" depending on whether \code{parameter} is in the argument or URL format}

\item{to}{character; one of "argument" or "url"}
}
\value{
character; name of the parameter used in the URL request or \code{build()} function. If no match is found, \code{character(0)}
}
\description{
The names of the parameters that are used in the R functions do not perfectly correspond with the parameter name expected by the API. This
function converts an argument parameter name (e.g. \code{settlement_date}) to the URL argument name (e.g. \code{SettlementDate}) or the other way around
}
