% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_legacy_call}
\alias{build_legacy_call}
\title{Create an API call for legacy data}
\usage{
build_legacy_call(
  data_item,
  api_key,
  from_date = NULL,
  to_date = NULL,
  settlement_date = NULL,
  settlement_period = NULL,
  bm_unit_id = NULL,
  bm_unit_type = NULL,
  lead_party_name = NULL,
  ngc_bm_unit_name = NULL,
  from_cleared_date = NULL,
  to_cleared_date = NULL,
  is_two_day_window = NULL,
  from_datetime = NULL,
  to_datetime = NULL,
  from_settlement_date = NULL,
  to_settlement_date = NULL,
  period = NULL,
  fuel_type = NULL,
  balancing_service_volume = NULL,
  zone_identifier = NULL,
  start_time = NULL,
  end_time = NULL,
  trade_name = NULL,
  trade_type = NULL,
  api_version = "v1",
  service_type = "csv",
  ...
)
}
\arguments{
\item{data_item}{character string; the id of the legacy data}

\item{api_key}{character string; api key retrieved from the Elexon portal}

\item{from_date}{character string; from date (automatically cleaned by format_date)}

\item{to_date}{character string; to date (automatically cleaned by format_date)}

\item{settlement_date}{character string; settlement date (automatically cleaned by format_date)}

\item{settlement_period}{character string; settlement period}

\item{bm_unit_id}{character string; BM Unit ID}

\item{bm_unit_type}{character string; BM Unit type}

\item{lead_party_name}{character string;  lead party name}

\item{ngc_bm_unit_name}{character string; NGC BM Unit name}

\item{from_cleared_date}{character string; from cleared date (automatically cleaned by format_date)}

\item{to_cleared_date}{character string; to cleared dat (automatically cleaned by format_date)}

\item{is_two_day_window}{character string; is two day window}

\item{from_datetime}{character string; from datetime}

\item{to_datetime}{character string; to datetime}

\item{from_settlement_date}{character string; from settlement date (automatically cleaned by format_date)}

\item{to_settlement_date}{character string; to settlement date (automatically cleaned by format_date)}

\item{period}{character string; period}

\item{fuel_type}{character string; fuel type}

\item{balancing_service_volume}{character string; balancing service volume}

\item{zone_identifier}{character string; zone identifier}

\item{start_time}{character string; start time}

\item{end_time}{character string; end time}

\item{trade_name}{character string; trade name}

\item{trade_type}{character string; trade type}

\item{api_version}{character string; version of the api to use (currently on v1)}

\item{service_type}{character string; file format (csv or xml)}

\item{...}{additional parameters that will be appended onto the query string}
}
\value{
list; list with entries \code{url} for the call, \code{service_type} and \code{data_item}
}
\description{
Create an API call for legacy data
}
\examples{
build_legacy_call(data_item = "FUELINST", api_key = "12345",
from_datetime = "14-12-201613:00:00", to_datetime = "14-12-201614:00:00")
build_legacy_call(data_item = "QAS", api_key = "12345",
settlement_date = "01 Jun 2019", service_type = "xml")
}
\seealso{
Other call-building functions: 
\code{\link{build_b_call}()},
\code{\link{build_call}()},
\code{\link{build_remit_call}()}
}
\concept{call-building functions}
