% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_mixture_probs_by_cov}
\alias{get_mixture_probs_by_cov}
\title{Duration Times Plot: Heat-map of Mixture Probabilities for Different Covariates}
\usage{
get_mixture_probs_by_cov(
  results,
  cov_labels = NULL,
  cov_index = 1:ncol(results$Xexgns),
  decimal_pts = 2,
  include_plot = FALSE
)
}
\arguments{
\item{results}{results of duration times, i.e., results$results_duration}

\item{cov_labels}{a matrix such that row i represents the labels for covariate i; default labels for covariate i is 1:i}

\item{cov_index}{a vector of indices of covariate to plot; default is 1:Num_Covariates}

\item{decimal_pts}{specify the number of decimal points of the results; default is 2}

\item{include_plot}{display plot if TRUE; default is FALSE}
}
\value{
No return value, called for printing and plotting heatmaps for mixture probabilities for each covariate.
}
\description{
Print and plot the heat-map of mixture probabilities for covariate levels
}
\details{
Print a matrix for each covariate.
Each matrix has K rows, where K is the number of components.
The number of columns of a matrix equals to the total number of levels of the covariate.
}
\examples{
results <- BMRMM(foxp2_sm,num_cov=2,simsize=50)
get_mixture_probs_by_cov(results$results_duration) 
get_mixture_probs_by_cov(results$results_duration,cov_index=c(1,2))
}
