% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_mixture_params}
\alias{get_mixture_params}
\title{Duration Times Plot: Heat-map of Mixture Gamma Shape & Rate Parameters}
\usage{
get_mixture_params(results, decimal_pts = 2, include_plot = FALSE)
}
\arguments{
\item{results}{results of duration times, i.e., results$results_duration}

\item{decimal_pts}{specify the number of decimal points of the results; default is 2}

\item{include_plot}{display plot if TRUE; default is FALSE}
}
\value{
No return value, called for printing and plotting heatmaps for mixture parameters.
}
\description{
Print and plot the heat-map for the gamma mixture parameters for each component
}
\details{
Print a matrix of size K*2, where K is the number of components.
Each row i represents the shape and rate parameter of component i.
}
\examples{
results <- BMRMM(foxp2_sm,num_cov=2,simsize=50)
get_mixture_params(results$results_duration)

}
