% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_B}
\alias{sim_B}
\title{Simulate dataset B: AR(1)-correlated continuous covariates with MCAR/MAR missingness}
\usage{
sim_B(
  n = 100,
  p = 20,
  low_missing = TRUE,
  type = "MAR",
  SNP = 1.5,
  corr = 0.5,
  n_imp = 5,
  seed = NULL
)
}
\arguments{
\item{n}{Integer. Number of observations.}

\item{p}{Integer. Number of covariates (columns). Takes values in \{20, 40\}.}

\item{low_missing}{Logical. If TRUE, use low missingness rates; if FALSE, higher missingness.}

\item{type}{Character. Missingness mechanism: "MCAR" or "MAR".}

\item{SNP}{Numeric. Signal-to-noise ratio controlling error variance.}

\item{corr}{Numeric. AR(1) correlation parameter}

\item{n_imp}{Integer. Number of multiple imputations to generate.}

\item{seed}{Integer or NULL. Random seed for reproducibility.}
}
\value{
A list with components:
\describe{
\item{data_O}{A list of complete covariate matrix and outcomes before missingness.}
\item{data_mis}{A list of covariate matrix and outcomes with missing values.}
\item{data_MI}{A list of array of imputed covariates (n_imp × n × p) and a matrix of imputed outcomes (n_imp × n).}
\item{data_CC}{A list of complete-case covariate matrix and outcomes.}
\item{important}{Logical vector of true nonzero coefficient indices.}
\item{covmat}{True covariance matrix used for X.}
\item{beta}{True coefficient vector.}
}
}
\description{
Generates a dataset for Scenario B used in Bayesian MI-LASSO benchmarking. Covariates are multivariate normal with AR(1) covariance,
with a fixed true coefficient vector, linear outcome, missingness imposed on specified columns under MCAR or MAR,
and multiple imputations via predictive mean matching.
}
\examples{
sim <- sim_B(n = 100, p = 20, type = "MAR", SNP = 1.5, corr = 0.5,
             low_missing = TRUE, n_imp = 5, seed = 123)
str(sim)
}
