% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreVisits.r
\name{spatialVisits}
\alias{spatialVisits}
\title{A function to make the exploreVisits Spatial}
\usage{
spatialVisits(
  x,
  xyCols = c("centroidX", "centroidY"),
  dataCRS = "+init=epsg:4326",
  radius = "medianDist"
)
}
\arguments{
\item{x}{an object of class \sQuote{data.frame} from exploreVistis.}

\item{xyCols}{a character vector with the column names for the coordinates.
Default to \code{c("centroidX","centroidY")}}

\item{dataCRS}{a character string with the proj4 description of the original
coordinate projeciton system (CRS). Default to \code{"+init=epsg:4326"}}

\item{radius}{either a character string with the name of the column
containing the radius of the visit circle, or a numeric vector with its value
in meters. Default to \code{"medianDist"}}
}
\value{
a list with a \code{SpatialPointsDataFrame} (the centroids) and a
\code{ "SpatialPolygonsDataFrame"} (the effort circles). Note that when plotted
directly effort circles may not look like circles in the returned
(Pseudo-Mercator) projection.
}
\description{
A function to
}
\examples{
# create a visit-based data object from the original observation-based data
library(sp)
OB<-organizeBirds(bombusObsShort)
visitStats<-exploreVisits(OB)
spV<-spatialVisits(visitStats)
plot(spV$effort)
}
\seealso{
\code{\link{exploreVisits}}, \code{\link{organiseBirds}}
}
