% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryByPlot.R
\name{summaryByPlot}
\alias{summaryByPlot}
\title{Summarise by plot the posterior distribution of AGB values}
\usage{
summaryByPlot(AGB_val, plot, drawPlot = FALSE)
}
\arguments{
\item{AGB_val}{Matrix resulting from the \code{\link[=AGBmonteCarlo]{AGBmonteCarlo()}} function (AGB_val element of the list), or just the output of the \code{\link[=AGBmonteCarlo]{AGBmonteCarlo()}} function.}

\item{plot}{Vector corresponding to the plots code (plots ID)}

\item{drawPlot}{A logic indicating whether the graphic should be displayed or not}
}
\value{
a data frame where:
\itemize{
\item \code{plot}: the code of the plot
\item \code{AGB}: AGB value at the plot level
\item \code{Cred_2.5}: the 2.5\\% quantile for the plot
\item \code{Cred_97.5}: the 97.5\\% quantile for the plot
}
}
\description{
This function summarizes the matrix \code{AGB_val} given by the function \code{\link[=AGBmonteCarlo]{AGBmonteCarlo()}} by plot.
}
\details{
If some trees belong to an unknown plot (i.e. NA value in the plot arguments), their AGB values are randomly assigned
to a plot at each iteration of the AGB monte Carlo approach.
}
\examples{

# Load a database
data(NouraguesHD)
data(NouraguesTrees)

# Modelling height-diameter relationship
HDmodel <- modelHD(D = NouraguesHD$D, H = NouraguesHD$H, method = "log2")

# Retrieving wood density values
\donttest{
  NouraguesWD <- getWoodDensity(NouraguesTrees$Genus, NouraguesTrees$Species,
                                stand = NouraguesTrees$plotId)
}

# Propagating errors
\donttest{
  resultMC <- AGBmonteCarlo(
    D = NouraguesTrees$D, WD = NouraguesWD$meanWD,
    errWD = NouraguesWD$sdWD, HDmodel = HDmodel )
  
  # The summary by plot
  summaryByPlot(AGB_val = resultMC$AGB_simu, plot = NouraguesTrees$Plot)
}

}
