% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrapData}
\alias{bootstrapData}
\title{Data generating function used for constructing null distribution of meanR and
maxR statistics}
\usage{
bootstrapData(data, fitResult, transforms = fitResult$transforms,
  null_model = c("loewe", "hsa", "bliss", "loewe2"), ...)
}
\arguments{
\item{data}{Dose-response dataframe.}

\item{fitResult}{Monotherapy (on-axis) model fit, e.g. produced by
\code{\link{fitMarginals}}. It has to be a \code{"MarginalFit"} object or a
list containing \code{df}, \code{sigma}, \code{coef},
\code{shared_asymptote} and \code{method} elements for, respectively,
marginal model degrees of freedom, residual standard deviation, named
vector of coefficient estimates, logical value of whether shared asymptote
is imposed and method for estimating marginal models during bootstrapping
(see \code{\link{fitMarginals}}). If biological and power transformations
were used in marginal model estimation, \code{fitResult} should contain
\code{transforms} elements with these transformations. Alternatively, these
can also be specified via \code{transforms} argument.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{null_model}{Specified null model for the expected response surface.
Currently, allowed options are \code{"loewe"} for generalized Loewe model,
\code{"hsa"} for Highest Single Agent model, \code{"bliss"} for Bliss additivity,
and \code{"loewe2"} for the alternative Loewe generalization.}

\item{...}{Further arguments that will be passed to
\code{\link{generateData}} function}
}
\description{
This function uses \code{\link{simulateNull}} and simulates all necessary
steps to calculate null distribution which will furtherly be used in either
\code{\link{meanR}} or \code{\link{maxR}} functions.
}
