% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_county}
\alias{BIEN_list_county}
\title{Extract a species list by county.}
\usage{
BIEN_list_county(country, state, county, cultivated = FALSE,
  only.new.world = TRUE, ...)
}
\arguments{
\item{country}{A single country or vector of countries}

\item{state}{A single state or vector of states.}

\item{county}{A single county or vector of counties.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing species list(s) for the specified states/provinces.
}
\description{
BIEN_list_county produces a list of all species with geovalidated occurrences falling within specified county or counties.
}
\note{
This function requires you supply either 1) a single state and country with one or more counties, or 2) vectors of equal length for each political level.
}
\examples{
\dontrun{
BIEN_list_county("United States", "Michigan", "Kent")
BIEN_list_county(country = "United States", state = "Michigan", county = "Kent")
county_vector<-c("Kent","Kalamazoo")
BIEN_list_county(country = "United States", state = "Michigan", county = county_vector)}
}
\seealso{
Other list functions: \code{\link{BIEN_list_all}},
  \code{\link{BIEN_list_country}},
  \code{\link{BIEN_list_shapefile}},
  \code{\link{BIEN_list_state}}
}
