% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGVAR.R
\name{fitted}
\alias{fitted}
\alias{fitted.bgvar}
\title{Extract Fitted Values of Bayesian GVAR}
\usage{
\method{fitted}{bgvar}(object, ..., global = TRUE)
}
\arguments{
\item{object}{An object of class \code{bgvar}.}

\item{...}{Additional arguments.}

\item{global}{If \code{global=TRUE} global fitted values are returned otherwise country fitted values.}
}
\value{
Returns an \code{T} times \code{K} matrix, where \code{T} is the number of observations and \code{K} number of endogenous variables.
}
\description{
Extracts the fitted values for \code{bgvar}.
}
\examples{
\donttest{
library(BGVAR)
data(eerDatasmall)
model.ng <- bgvar(Data=eerDatasmall,W=W.trade0012.small,plag=1,draws=100,burnin=100)
fitted(model.ng)
}
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
}
