% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGVAR.R
\name{residuals}
\alias{residuals}
\alias{residuals.bgvar}
\alias{resid.bgvar}
\title{Extract Residuals of Bayesian GVAR}
\usage{
\method{residuals}{bgvar}(object, ...)

\method{resid}{bgvar}(object, ...)
}
\arguments{
\item{object}{a fitted \code{bgvar} object.}

\item{...}{other arguments.}
}
\value{
returns a list with the following arguments \itemize{
\item{\code{global}}{ is a (T-p) times K times draws/thin array containing the residuals of the global model.}
\item{\code{country}}{ is a (T-p) times K times draws/thin array containing the residuals of the country models.}
\item{\code{Data}}{ is a (T-p) times K matrix containing the data of the model.}
}
}
\description{
Calculate residuals of the global model and the country models.
}
\details{
This function calculates residuals of the global and the country models based on a \code{bgvar} object. Country models' residuals are equivalent to output generated by the \code{print.bgvar} function in case no trimming has been used. If trimming was invoked to discard unstable draws output of both functions might differ since \code{print.bgvar} calculates residuals as a running mean to save storage which is based on the \emph{whole} set of posterior draws (including discarded draws). In this case it is recommended to recalculate the residuals with \code{residuals.bgvar} and re-do the serial autocorrelation or average pairwise cross-correlation analysis using functions \code{resid.corr.test} and \code{avg.pair.cc}.
}
\examples{
\donttest{
library(BGVAR)
data(eerDatasmall)
model.ng <- bgvar(Data=eerDatasmall,W=W.trade0012.small,plag=1,draws=100,burnin=100)
resid(model.ng)
}
\donttest{
resid(model.ng)
}
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
}
\author{
Maximilian Boeck, Martin Feldkircher
}
