% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{Vaccine}
\alias{Vaccine}
\alias{c.pts}
\alias{cost.GP}
\alias{cost.hosp}
\alias{cost.otc}
\alias{cost.time.off}
\alias{cost.time.vac}
\alias{cost.travel}
\alias{cost.trt1}
\alias{cost.trt2}
\alias{cost.vac}
\alias{e.pts}
\alias{N}
\alias{N.outcomes}
\alias{N.resources}
\alias{QALYs.adv}
\alias{QALYs.death}
\alias{QALYs.hosp}
\alias{QALYs.inf}
\alias{QALYs.pne}
\alias{vaccine_mat}
\title{Influenza Vaccination Cost-Effectiveness Data}
\format{
A list containing variables for the influenza vaccination model:
\describe{
\item{cost}{A matrix of simulations of the overall costs for the two treatments.}
\item{c.pts}{Coordinates for plotting cost distributions.}
\item{cost.GP}{A matrix of simulations of the costs for GP visits.}
\item{cost.hosp}{A matrix of simulations of the costs for hospitalisations.}
\item{cost.otc}{A matrix of simulations of the costs for over-the-counter medications.}
\item{cost.time.off}{A matrix of simulations of the costs for time off work.}
\item{cost.time.vac}{A matrix of simulations of the costs for time to get vaccinated.}
\item{cost.travel}{A matrix of simulations of the costs for travel to get vaccinated.}
\item{cost.trt1}{A matrix of simulations of the overall costs for first-line treatment.}
\item{cost.trt2}{A matrix of simulations of the overall costs for second-line treatment.}
\item{cost.vac}{A matrix of simulations of the costs for vaccination.}
\item{eff}{A matrix of simulations of the clinical benefits.}
\item{e.pts}{Coordinates for plotting effectiveness distributions.}
\item{N}{The number of subjects in the reference population.}
\item{N.outcomes}{The number of clinical outcomes analysed.}
\item{N.resources}{The number of health-care resources under study.}
\item{QALYs.adv}{A vector of QALYs associated with adverse events.}
\item{QALYs.death}{A vector of QALYs associated with death.}
\item{QALYs.hosp}{A vector of QALYs associated with hospitalisation.}
\item{QALYs.inf}{A vector of QALYs associated with influenza infection.}
\item{QALYs.pne}{A vector of QALYs associated with pneumonia.}
\item{treats}{A character vector of labels for the two treatments.}
\item{vaccine_mat}{A matrix of simulations for the parameters in the original model.}
}
}
\source{
Adapted from Turner D, et al. (2006). "The cost-effectiveness of
influenza vaccination of healthy adults 50-64 years of age". \emph{Vaccine}, 24:1035-1043.
}
\description{
This data set contains the results of a Bayesian analysis modeling the
clinical outputs and costs associated with an influenza vaccination program.
}
\references{
Baio, G., & Dawid, A. P. (2011). "Probabilistic Sensitivity
Analysis in Health Economics". \emph{Statistical Methods in Medical Research}.
doi:10.1177/0962280211419832.
}
\keyword{datasets}
