% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similar_players.R
\name{get_similar_players}
\alias{get_similar_players}
\title{Similar players to archetypoids}
\usage{
get_similar_players(atype, threshold, alphas, cases, data, variables, compet, season)
}
\arguments{
\item{atype}{Number assigned to the archetypoid (1:length(\code{cases})) from which
searching the players who most resemble to it.}

\item{threshold}{Similarity threshold.}

\item{alphas}{Alpha values of all the players.}

\item{cases}{Archetypoids.}

\item{data}{Data frame with the statistics.}

\item{variables}{Statistics used to compute the archetypoids.}

\item{compet}{Competition.}

\item{season}{Season.}
}
\value{
Data frame with the features of the similar players.
}
\description{
Similar players to the archetypoids computed with 
\code{\link[Anthropometry]{archetypoids}} according to a similarity threshold.
}
\examples{
(s0 <- Sys.time())
# Turn off temporarily some negligible warnings from the 
# archetypes package to avoid missunderstandings. The code works well.
oldw <- getOption("warn")
options(warn = -1)
library(Anthropometry)
df <- do_join_games_bio("ACB", acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
df2 <- do_stats(df1, "Total", "2017-2018", "ACB", "Regular Season")
df3 <- df2[which(df2$Position == "Guard")[1:31], c("MP", "PTS", "Name")]
preproc <- preprocessing(df3[,1:2], stand = TRUE, percAccomm = 1)
set.seed(4321)
lass <- stepArchetypesRawData(preproc$data, 1:2, numRep = 20, verbose = FALSE)
res <- archetypoids(2, preproc$data, huge = 200, step = FALSE, ArchObj = lass,
                    nearest = "cand_ns", sequ = TRUE)
cases <- anthrCases(res)
df3[cases,]
alphas <- round(res$alphas, 4)
df3_aux <- df2[which(df2$Position == "Guard")[1:31], ]
get_similar_players(1, 0.99, alphas, cases, df3_aux, c("MP", "PTS"), 
                    unique(df3_aux$Compet), unique(df3_aux$Season))
options(warn = oldw)                     
s1 <- Sys.time() - s0
s1                    

}
\seealso{
\code{\link[Anthropometry]{archetypoids}}
}
\author{
Guillermo Vinue
}
