% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/BAT.R
\name{dispersion}
\alias{dispersion}
\title{Phylogenetic/functional dispersion of individuals or species.}
\usage{
dispersion(comm, tree, abund = TRUE, relative = FALSE)
}
\arguments{
\item{comm}{A sites x species matrix, with either abundance or incidence data.}

\item{tree}{An hclust or phylo object.}

\item{abund}{A boolean (T/F) indicating whether dissimilarity should be calculated per individual (T) or species (F). If not specified, default is TRUE.}

\item{relative}{A boolean (T/F) indicating whether dissimilarity should be relative to the maximum distance between any two species in the tree.}
}
\value{
A vector of values per site.
}
\description{
Average dissimilarity between any two individuals or species randomly chosen in a community with replacement.
}
\details{
If abundance data is used and a tree is given, dispersion is the quadratic entropy of Rao (1982).
If abundance data is not used but a tree is given, dispersion is the phylogenetic dispersion measure of Webb et al. (2002) although with replacement.
If abundance data is used but no tree is given, dispersion is 1 - Simpson's index (Simpson 1949).
}
\examples{
comm <- matrix(c(1,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,0,2,2), nrow = 4, byrow = TRUE)
tree <- hclust(dist(c(1:5), method="euclidean"), method="average")
dispersion(comm)
dispersion(comm, tree)
dispersion(comm, tree, abund = FALSE)
dispersion(comm, tree, abund = FALSE, relative = TRUE)
}
\references{
Rao, C.R. (1982) Diversity and dissimilarity coefficients: a unified approach. Theoretical Population Biology, 21: 24-43.

Simpson, E.H. (1949) Measurement of diversity. Nature 163: 688.

Webb, C.O., Ackerly, D.D., McPeek, M.A. & Donoghue, M.J. (2002) Phylogenies and community ecology. Annual Review of Ecology and Systematics, 33: 475-505.
}

