% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{variable.names.pred.bas}
\alias{variable.names.pred.bas}
\alias{variable.names}
\title{Extract the variable names for a model from a BAS prediction object}
\usage{
\method{variable.names}{pred.bas}(object, ...)
}
\arguments{
\item{object}{a BAS object created by \code{predict} from a BAS
`bas.lm` or `bas.glm` object}

\item{...}{other arguments to pass on}
}
\value{
a character vector with the names of the variables
included in the selected model; in the case of 'BMA' this will
be all variables
}
\description{
S3 method for class 'pred.bas'.  Simple utility
function to extract the variable names.  Used to print names
for the selected models using estimators for 'HPM', 'MPM' or 'BPM".
for the selected model created by \code{predict} for BAS
objects.
}
\examples{
data(Hald)
hald.gprior =  bas.lm(Y~ ., data=Hald, prior="ZS-null", modelprior=uniform())
hald.bpm = predict(hald.gprior, newdata=Hald[1,],
                   se.fit=TRUE,
                   estimator="BPM")
variable.names(hald.bpm)
}
\seealso{
\code{\link{predict.bas}}

Other predict methods: \code{\link{fitted.bas}},
  \code{\link{predict.basglm}}, \code{\link{predict.bas}}

Other bas methods: \code{\link{BAS}}, \code{\link{bas.lm}},
  \code{\link{coef.bas}}, \code{\link{confint.coef.bas}},
  \code{\link{confint.pred.bas}},
  \code{\link{diagnostics}}, \code{\link{fitted.bas}},
  \code{\link{force.heredity.bas}},
  \code{\link{image.bas}}, \code{\link{predict.basglm}},
  \code{\link{predict.bas}}, \code{\link{summary.bas}},
  \code{\link{update.bas}}
}
\concept{bas methods}
\concept{predict methods}
