% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getShiftNodesFromIndex.R
\name{getShiftNodesFromIndex}
\alias{getShiftNodesFromIndex}
\title{Identify nodes associated with rate shifts from \code{bammdata}
    object}
\usage{
getShiftNodesFromIndex(ephy, index)
}
\arguments{
\item{ephy}{A \code{bammdata} object.}

\item{index}{The index value of the posterior sample from which you want
to identify shift nodes. This is \emph{not} the same as the actual
generation number of the MCMC sample. If your \code{bammdata} object
contains 100 samples from the posterior distribution, the value of
\code{index} must range from 1 to 100.}
}
\value{
A vector of nodes (excluding the root) that define branches on
    which shifts occurred for the specified sample from the posterior.
    Will return a numeric of length 0 if no non-root shifts occur in the
    specified sample.
}
\description{
Find the node numbers associated with rate shifts for a
    specified sample from the posterior distribution contained in a
    \code{bammdata} object.
}
\examples{
data(whales, events.whales)
ed <- getEventData(whales, events.whales, burnin=0.1, nsamples=500)

# Get the maximum shift credibility configuration:
msc <- maximumShiftCredibility(ed)

# Get the nodes at which shifts occurred in the 
# maximum shift credibility configuration:

getShiftNodesFromIndex(ed, index=msc$sampleindex)
}
\author{
Dan Rabosky
}
\seealso{
\code{\link{addBAMMshifts}}, \code{\link{plot.bammdata}},
\code{\link{maximumShiftCredibility}}
}
\keyword{models}

