\name{BBplot}
\alias{BBplot}
\title{
To compare enriched functional annotations found by using DAVID webservice.
}
\description{
It uses a list of DAVIDFunctionalAnnotationChart objects to build a chart that shows how the functional annotations found by DAVID have changed across different experimental conditions.
BBplot function can work with any kind of gene list and not only with up/down regulated gene lists. 
}
\usage{
BBplot(list.david.obj, max.pval = 0.01, min.ngenes = 5, title = "BBplot", 
       name.com = "***", labels = c("down", "up"), colors = c("#009E73", "red"),
       print.term = "full")
}
\arguments{
  \item{list.david.obj}{
   (Required). List of DAVIDFunctionalAnnotationChart objects.
}
  \item{max.pval}{
   (Optional). Numeric with the p-value that must be present in order to select the most significant enriched annotations. Default values is 0.01.
}
  \item{min.ngenes}{
   (Optional). Integer with the minimum number of genes (greater or equal) that must be present in an enriched annotations. Default values is 5.
}
  \item{title}{
   (Optional). Character with the name of the buble plot. Default valuse is "Bubble plot". 
}
  \item{name.com}{
   (Optional). Character vector indicating the experimental conditions. 
}
  \item{labels}{
   (Optional). Character vector to specify the name used to indicate the down- and up-regulated gene lists. The default value is c("down", "up").
}
  \item{colors}{
   (Optional). Character vector to specify the colors used to distinguish down- and up-regulated gene lists. The default value is c("#009E73", "red").
}
  \item{print.term}{
   (Optional). Character vector to specify the term used to indicate the annotation: 'full', 'name' or 'description'. The default value is "full".
}
}
\details{
The list of DAVIDFunctionalAnnotationChart objects should be generated by using the function \code{\link{DAVIDsearch}}.
}
\value{
Return a ggplot2 graph.
}
\author{
Vittorio Fortino
}
\note{
For each condition, provide two DAVIDFunctionalAnnotationChart objects: one for the up-regulated genes and other for the down-regulated genes.
}

\seealso{
\code{\link{DAVIDsearch}} 
} 
\examples{
  data(result.kegg)

  bbplot.kegg <- BBplot(result.kegg, max.pval = 0.05, min.ngenes = 10, 
                    name.com = c("Cond.1_12h","Cond.1_24h","Cond.2_12h","Cond.2_24h"), 
                    labels = c("down", "up"), colors = c("#009E73", "red"), 
                    title = "BBplot - KEGG", print.term = "full")
  bbplot.kegg
  ##ggsave("KEGG_terms.tiff", width=6, height=4, scale=2, dpi=200)
  
 }
