% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_url}
\alias{is_url}
\alias{get_paged_list}
\title{Miscellaneous utility functions}
\usage{
is_url(x, https_only = FALSE)

get_paged_list(lst, token, next_link_name = "nextLink",
  value_name = "value")
}
\arguments{
\item{x}{For \code{is_url}, An R object.}

\item{https_only}{For \code{is_url}, whether to allow only HTTPS URLs.}

\item{lst}{A named list of objects.}

\item{token}{For \code{get_paged_list}, an Azure OAuth token, of class \link{AzureToken}.}

\item{next_link_name, value_name}{For \code{get_paged_list}, the names of the next link and value components in the \code{lst} argument. The default values are correct for Resource Manager.}
}
\value{
For \code{get_paged_list}, a list.

For \code{is_url}, whether the object appears to be a URL (is character of length 1, and starts with the string \code{"http"}). Optionally, restricts the check to HTTPS URLs only.
}
\description{
Miscellaneous utility functions
}
\details{
\code{get_paged_list} reconstructs a complete list of objects from a paged response. Many Resource Manager list operations will return \emph{paged} output, that is, the response contains a subset of all items, along with a URL to query to retrieve the next subset. \code{get_paged_list} retrieves each subset and returns all items in a single list.
}
