% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_role.R
\docType{class}
\name{az_role_definition}
\alias{az_role_definition}
\title{Azure role definition class}
\format{
An R6 object of class \code{az_role_definition}.
}
\description{
Azure role definition class
}
\section{Fields}{

\itemize{
\item \code{id}: The full resource ID for this role definition.
\item \code{type}: The resource type for a role definition. Always \code{Microsoft.Authorization/roleDefinitions}.
\item \code{name}: A GUID that identifies this role definition.
\item \code{properties}: Properties for the role definition.
}
}

\section{Methods}{

This class has no methods.
}

\section{Initialization}{

The recommended way to create new instances of this class is via the \link{get_role_definition} method for subscription, resource group and resource objects.

Technically role assignments and role definitions are Azure \emph{resources}, and could be implemented as subclasses of \code{az_resource}. AzureRMR treats them as distinct, due to limited RBAC functionality currently supported. In particular, role definitions are read-only: you can retrieve a definition, but not modify it, nor create new definitions.
}

\seealso{
\link{get_role_definition}, \link{get_role_assignment}, \link{az_role_assignment}

\href{https://docs.microsoft.com/en-us/azure/role-based-access-control/overview}{Overview of role-based access control}
}
