% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_parity.R
\name{risk_parity}
\alias{risk_parity}
\title{Returns risk parity weights on a given date}
\usage{
risk_parity(strat, reb_date, P, R, risk_free = NULL)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{risk_parity} determines asset allocations using a risk parity rule.
It obtains the weights such that all assets provide the same risk
contribution to the risk of the portfolio.
}
\details{
The function calculates the covariance matrix of returns using the last two
years (or minimum of one year) of daily returns.
}
\examples{
ivy  <- asset_allocations$tactical$ivy
reb_date <- as.Date("2022-03-31")
risk_parity(ivy, reb_date, ETFs$Prices[, ivy$tickers], ETFs$Returns[, ivy$tickers])
}
