% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhasesGap.R
\name{phases_gap}
\alias{phases_gap}
\title{Gap or hiatus between two successive phases (for phases in temporal order constraint)}
\usage{
phases_gap(a_chain, b_chain, level = 0.95)
}
\arguments{
\item{a_chain}{Numeric vector containing the output of the MCMC
algorithm for the upper boundary of the older phase.}

\item{b_chain}{Numeric vector containing the output of the MCMC
algorithm for the lower boundary of the younger phase.}

\item{level}{Probability corresponding to the level of confidence.}
}
\value{
A list with the following components:
\describe{
\item{hiatus}{A named vector where \code{inf} is the lower endpoint of the
hiatus as a calendar year (AD/BC) or \code{NA} if there is no hiatus at
\code{level}, and \code{sup} is the upper endpoint of the gap as a calendar
year (AD/BC), or \code{NA} if there is no hiatus at \code{level}.}
\item{level}{Probability corresponding to the confidence level of the
interval.}
\item{call}{The function call.}
}
}
\description{
This function finds, if it exists, a gap or hiatus between two successive phases.
This gap or hiatus is the longest interval that satisfies
\eqn{P(Phase1Max_chain < IntervalInf < IntervalSup < Phase2Min_chain | M) = level}
}
\examples{
  data(Phases); attach(Phases)
  phases_gap(Phase.1.beta, Phase.2.alpha, 0.95)
  phases_gap(Phase.1.beta, Phase.2.alpha, 0.50)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}, and

Thomas S. Dye, \email{tsd@tsdye.online}
}
