% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardwareSprites.r, R/iff.ilbm.r
\docType{methods}
\name{as.raster}
\alias{as.raster}
\alias{as.raster,hardwareSprite-method}
\alias{as.raster}
\alias{as.raster,IFFChunk-method}
\title{Convert AmigaFFH objects into grDevices raster images}
\usage{
\S4method{as.raster}{hardwareSprite}(x, background = "#AAAAAA", ...)

\S4method{as.raster}{IFFChunk}(x, ...)
}
\arguments{
\item{x}{Object that needs to be converted into a \code{grDevices} raster. It
can be an \code{\link{IFFChunk}} containing an interleaved bitmap image
(ILBM) or animation (ANIM) or a \code{\link{hardwareSprite}}.}

\item{background}{Use the argument \code{background} to
specify a background colour in case \code{x} is a \code{\link{hardwareSprite}}.}

\item{...}{Currently ignored.}
}
\value{
Returns a \code{grDevices} raster image (\code{\link[grDevices]{as.raster}})
based on \code{x}. If \code{x} is an animation (ANIM), a \code{list} of raster objects is
returned.
}
\description{
Convert AmigaFFH objects that contain bitmap images into grDevices raster
images.
}
\details{
Images on the Amiga were stored as bitmap images with indexed colour
palettes. This was mainly due to hardware and memory limitations.
Bitmap images could also be embedded in several file types. This method
can be used to convert AmigaFFH objects read from such files into
grDevices raster images (\code{\link[grDevices]{as.raster}}).
}
\examples{
\dontrun{
## load an IFF file
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## The file contains an interleaved bitmap image that can be
## converted into a raster:
example.raster <- as.raster(example.iff)

## the raster can be plotted:
plot(example.raster)

## note that the IFFChunk can also be plotted directly:
plot(example.iff)

## Hardware sprites can also be converted into raster images.
## Let's generate a 16x16 sprite with a random bitmap:
spr <- new("hardwareSprite",
           VStop = 16,
           bitmap = as.raw(sample.int(255, 64, replace = TRUE)))

## now convert it into a raster image.
## as the background colour is not specified for hardware
## sprite, we can optionally provide it here.
spr.raster <- as.raster(spr, background = "green")
}
}
\seealso{
Other iff.operations: \code{\link{IFFChunk-class}},
  \code{\link{WaveToIFF}}, \code{\link{as.raw}},
  \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{read.iff}},
  \code{\link{write.iff}}

Other raster.operations: \code{\link{bitmapToRaster}},
  \code{\link{dither}}, \code{\link{index.colours}},
  \code{\link{rasterToBitmap}}, \code{\link{rasterToIFF}}
}
\author{
Pepijn de Vries
}
