% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossing.R
\name{makeDH}
\alias{makeDH}
\title{Generates DH lines}
\usage{
makeDH(pop, nDH = 1, useFemale = TRUE, keepParents = TRUE, simParam = NULL)
}
\arguments{
\item{pop}{an object of 'Pop' superclass}

\item{nDH}{total number of DH lines per individual}

\item{useFemale}{should female recombination rates be used.}

\item{keepParents}{should previous parents be used for mother and 
father.}

\item{simParam}{an object of 'SimParam' class}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Creates DH lines from each individual in a population. 
Only works with diploid individuals. For polyploids, use 
\code{\link{reduceGenome}} and \code{\link{doubleGenome}}.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Create 1 DH for each individual
pop2 = makeDH(pop, simParam=SP)

}
