% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GS.R
\name{setEBV}
\alias{setEBV}
\title{Set EBV}
\usage{
setEBV(pop, solution, gender = NULL, useGV = FALSE, append = FALSE,
  simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{solution}{an object of \code{\link{RRsol-class}},
\code{\link{SCAsol-class}}, or \code{\link{GCAsol-class}}}

\item{gender}{either NULL, "male" or "female". If 
solution is \code{\link{GCAsol-class}} or 
\code{\link{SCAsol-class}} the EBV is the GCA if used in 
the corresponding pool}

\item{useGV}{if model is \code{\link{RRDsol-class}}, 
setting this parameter to TRUE will give use estimated 
genetic values. Otherwise, you get estimated breeding 
values that depend on the population's allele frequency.}

\item{append}{should EBVs be appended to existing EBVs}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Sets a population's EBV with genomic estimated
values from \code{\link{RRBLUP}}, \code{\link{RRBLUP_GCA}},
or \code{\link{RRBLUP_SCA}}.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)
SP$addSnpChip(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Run GS model and set EBV
ans = RRBLUP(pop, simParam=SP)
pop = setEBV(pop, ans, simParam=SP)

#Evaluate accuracy
cor(gv(pop), ebv(pop))

}
