% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\docType{data}
\name{SimParam}
\alias{SimParam}
\title{Simulation parameters}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
SimParam
}
\description{
Container for global simulation parameters. Saving this object 
as SP will allow it to be accessed by function defaults.
}
\section{Fields}{

\describe{
\item{\code{nChr}}{number of chromosomes}

\item{\code{nTraits}}{number of traits}

\item{\code{nSnpChips}}{number of SNP chips}

\item{\code{segSites}}{segregating sites per chromosome}

\item{\code{gender}}{is gender used for mating}

\item{\code{genMap}}{"matrix" of chromosome genetic maps}

\item{\code{femaleMap}}{"matrix" of chromosome genetic maps for 
females}

\item{\code{maleMap}}{"matrix" of chromosome genetic maps for 
males}

\item{\code{sepMap}}{are there seperate genetic maps for 
males and females}

\item{\code{femaleCentromere}}{position of centromere on female 
genetic map}

\item{\code{maleCentromere}}{position of centromere on male 
genetic map}

\item{\code{recombRatio}}{ratio of genetic recombination in 
females relative to male}

\item{\code{traits}}{list of trait}

\item{\code{snpChips}}{list of SNP chips}

\item{\code{potQtl}}{list of potential QTL segregating sites}

\item{\code{potSnp}}{list of potential SNP segregating sites}

\item{\code{lastId}}{last ID number assigned}

\item{\code{isTrackPed}}{is pedigree being tracked}

\item{\code{pedigree}}{pedigree matrix for all individuals}

\item{\code{isTrackRec}}{is recombination being tracked}

\item{\code{recHist}}{list of historic recombination events}

\item{\code{varA}}{additive genetic variance in founderPop}

\item{\code{varG}}{total genetic variance in founderPop}

\item{\code{varE}}{default error variance}

\item{\code{founderPop}}{the founder population used for scaling traits}

\item{\code{v}}{the interference parameter for a gamma model of recombination}

\item{\code{quadProb}}{the probability of quadrivalent formation}

\item{\code{nThreads}}{number of threads used on platforms with OpenMP support}

\item{\code{version}}{the version of AlphaSimR used to generate this object}
}}

\keyword{datasets}
