% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setRecRatio}
\alias{SimParam_setRecRatio}
\title{Set gender specific recombination}
\arguments{
\item{ratio}{any value greater than 0}

\item{force}{should the check for a running simulation be 
ignored. Only set to TRUE if you know what you are doing.}
}
\description{
Defines a gender specific recombination ratio. 
The ratio is defined as the amount of recombination in 
females relative to male. Thus, a value of 1 (default) 
specifies equal recombination rates in both males and females. 
A value of 2 specifies twice as much recombination in females 
and a value of 0.5 specifies half as much recombination in 
females.
}
\section{Usage}{
 SP$setRecRatio(ratio, force = FALSE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setRecRatio(2) #Twice as much recombination in females

}
