% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_join.R
\name{sensor_join}
\alias{sensor_join}
\title{Join airsensor objects from different time periods}
\usage{
sensor_join(sensor1 = NULL, sensor2 = NULL)
}
\arguments{
\item{sensor1}{An AirSensor object.}

\item{sensor2}{An AirSensor object.}
}
\value{
An \emph{airsensor} object containing all data from both incoming objects.
}
\description{
AirSensor objects are "joined end-to-end" so that time ranges
are extended for all sensors that appear in either \code{sensor1} and 
\code{sensor2}.

Only two \code{airsensor} objects at a time may be joined.
}
\examples{
\donttest{
library(AirSensor)
setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

jan <- sensor_loadMonth("scaqmd", 202001)
feb <- sensor_loadMonth("scaqmd", 202002)
mar <- sensor_loadMonth("scaqmd", 202003)
apr <- sensor_loadMonth("scaqmd", 202004)

feb_mar <- sensor_join(feb, mar)
PWFSLSmoke::monitor_timeseriesPlot(feb_mar, style = 'gnats')

# Gaps in the time axis are filled with NA
feb_apr <- sensor_join(feb, apr)
PWFSLSmoke::monitor_timeseriesPlot(feb_apr, style = 'gnats')
}
}
