% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_filterDatetime.R
\name{sensor_filterDatetime}
\alias{sensor_filterDatetime}
\title{Datetime filtering for AirSensor objects}
\usage{
sensor_filterDatetime(
  sensor = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL
)
}
\arguments{
\item{sensor}{An AirSensor object.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret dates.}
}
\value{
A subset of the given \emph{sensor} object.
}
\description{
Subsets an AirSensor object by datetime. This function
allows for sub-day filtering as opposed to \code{sensor_filterDate()} which
always filters to day-boundaries. Filtering will be performed with
\code{>= startdate} and \code{< enddate} so that the \code{startdate}
timestep will be included in the output but the \code{enddate} will not.

Datetimes can be anything that is understood by 
\code{MazamaCoreUtils::parseDatetime()}. For non-\code{POSIXct} values,
the recommended format is \code{"YYYY-mm-dd HH:MM:SS"}.

Timezone determination precedence assumes that if you are passing in
POSIXct times then you know what you are doing.

\enumerate{
\item{get timezone from \code{startdate} if it is \code{POSIXct}}
\item{use passed in \code{timezone}}
\item{get timezone from \code{sensor}}
}
}
\examples{
library(AirSensor)

example_sensor \%>\% 
  sensor_extractData() \%>\%
  dplyr::pull("datetime") \%>\%
  range()
  
example_sensor \%>\% 
  sensor_filterDatetime(
    startdate = "2018-08-21 06:00:00", 
    enddate = "2018-08-28 18:00:00",
    timezone = "UTC"
  ) \%>\%
  sensor_extractData() \%>\%
  dplyr::pull("datetime") \%>\%
  range()

}
\seealso{
\link{sensor_filter}

\link{sensor_filterDate}
}
