% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_internalFit.R
\name{pat_internalFit}
\alias{pat_internalFit}
\title{Linear model fitting of channel A and B time series data}
\usage{
pat_internalFit(
  pat = NULL,
  showPlot = TRUE,
  size = 1,
  a_color = "red",
  b_color = "blue",
  alpha = 0.25,
  lr_shape = 15,
  lr_color = "black",
  lr_lwd = 1.5,
  lr_lcolor = "tomato",
  lr_lalpha = 0.45,
  ts_shape = 1,
  xylim = NULL
)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}

\item{showPlot}{Logical specifying whether to generate a model fit plot.}

\item{size}{Size of points.}

\item{a_color}{Color of time series channel A points.}

\item{b_color}{Color of time series channel B points.}

\item{alpha}{Opacity of points.}

\item{lr_shape}{Symbol to use for linear regression points.}

\item{lr_color}{Color of linear regression points.}

\item{lr_lwd}{Width of linear regression line.}

\item{lr_lcolor}{Color of linear regression line.}

\item{lr_lalpha}{Opacity of linear regression line.}

\item{ts_shape}{Symbol to use for time series points.}

\item{xylim}{Vector of (lo,hi) limits used as limits on the correlation plot 
axes -- useful for zooming in.}
}
\value{
A linear model, fitting the \code{pat} B channel readings to A channel 
readings.
}
\description{
Uses a linear model to fit data from channel B to data from 
channel A.

A diagnostic plot is produced if \code{showPlot = TRUE}.
}
\examples{
library(AirSensor)

example_pat \%>\%
  pat_internalFit()
}
