% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LL_analysis.R
\name{LL}
\alias{LL}
\title{Analysis: Logistic regression}
\usage{
LL(
  trat,
  resp,
  npar = "LL.3",
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  scale = "none"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{npar}{Number of model parameters}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
Logistic models with three (LL.3) or four (LL.4) continuous data parameters. This model was extracted from the drc package.
}
\details{
The three-parameter log-logistic function with lower limit 0 is
\deqn{f(x) = 0 + \frac{d}{1+\exp(b(\log(x)-\log(e)))}}
The four-parameter log-logistic function is given by the expression
\deqn{f(x) = c + \frac{d-c}{1+\exp(b(\log(x)-\log(e)))}}
The function is symmetric about the inflection point (e).
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
LL(trat,resp)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley \& Sons (p. 330).

Ritz, C.; Strebig, J.C.; Ritz, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
