% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TH1_function.R
\name{plot_TH1}
\alias{plot_TH1}
\title{Graph: Climate chart of temperature and humidity (Model 2)}
\usage{
plot_TH1(
  tempo,
  Tmed,
  Tmax,
  Tmin,
  UR,
  xlab = "Time",
  yname1 = expression("Humidity (\%)"),
  yname2 = expression("Temperature ("^o * "C)"),
  legend.T = "Temperature",
  legend.H = "Humidity",
  legend.tmed = "Tmed",
  legend.tmin = "Tmin",
  legend.tmax = "Tmax",
  colormax = "red",
  colormin = "blue",
  colormean = "darkgreen",
  fillarea = "darkblue",
  facet.fill = "#FF9933",
  panel.grid = FALSE,
  x = "days",
  breaks = "1 months",
  textsize = 12,
  legendsize = 12,
  titlesize = 12,
  linesize = 1,
  date_format = "\%m-\%Y",
  angle = 0,
  legend.position = c(0.1, 0.3)
)
}
\arguments{
\item{tempo}{Vector with times}

\item{Tmed}{Vector with mean temperature}

\item{Tmax}{Vector with maximum temperature}

\item{Tmin}{Vector with minimum temperature}

\item{UR}{Vector with relative humidity or precipitation}

\item{xlab}{x axis name}

\item{yname1}{y axis name}

\item{yname2}{Secondary y-axis name}

\item{legend.T}{faceted title legend 1}

\item{legend.H}{faceted title legend 2}

\item{legend.tmed}{Legend mean temperature}

\item{legend.tmin}{Legend minimum temperature}

\item{legend.tmax}{Legend maximum temperature}

\item{colormax}{Maximum line color (\emph{default} is "red")}

\item{colormin}{Minimum line color (\emph{default} is "blue")}

\item{colormean}{Midline color (\emph{default} is "darkgreen")}

\item{fillarea}{area fill color (\emph{default} is "darkblue")}

\item{facet.fill}{faceted title fill color (\emph{default} is #FF9933)}

\item{panel.grid}{remove grid line (\emph{default} is FALSE)}

\item{x}{x scale type (days or data, default is "days")}

\item{breaks}{Range for x scale when x = "date" (default is 1 months)}

\item{textsize}{Axis text size}

\item{legendsize}{Legend text size}

\item{titlesize}{Axis title size}

\item{linesize}{Line size}

\item{date_format}{Date format for x="data"}

\item{angle}{x-axis scale text rotation}

\item{legend.position}{Legend position}
}
\value{
Returns row and column graphs for graphical representation of air temperature and relative humidity. Graph normally used in scientific articles
}
\description{
The plot_TH1 function allows the user to build a column/line graph with climatic parameters of temperature (maximum, minimum and average) and relative humidity (UR) or precipitation. This chart is widely used in scientific work in agrarian science
}
\examples{
library(AgroR)
data(weather)
with(weather, plot_TH1(tempo, Tmed, Tmax, Tmin, UR))
}
\seealso{
\link{radargraph}, \link{sk_graph}, \link{barplot_positive}, \link{corgraph}, \link{spider_graph}, \link{line_plot}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
