% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_epi.R
\name{compile_epi}
\alias{compile_epi}
\title{Compile Epidemic Data}
\usage{
compile_epi(epidemic, individual_data, lags = 16, inf_period = 4, T = 300)
}
\arguments{
\item{epidemic}{A list of simulated epidemic data
(output from simepi() or similar function).}

\item{individual_data}{A data frame of simulated individuals data
(output from simulate_households() or similar function).}

\item{lags}{Maximum number of lags for absenteeism, default = 16
(note that lag of zero is included).}

\item{inf_period}{Infection period of epidemic, default = 4.}

\item{T}{Time period, default = 300 days.}
}
\value{
A data frame containing compiled epidemic data, including:
\item{Date}{Day of the epidemic}
\item{ScYr}{School year}
\item{pct_absent}{Percentage of students absent}
\item{absent}{Number of students absent}
\item{absent_sick}{Number of students absent due to illness}
\item{new_inf}{Number of new infections}
\item{reported_cases}{Number of reported cases}
\item{Case}{Indicator for lab confirmed flu case that day}
\item{sinterm, costerm}{Seasonal terms}
\item{window}{Indicator for "True Alarm" window}
\item{ref_date}{Indicator for reference date}
\item{lag0, lag1, ..., lag15}{Lagged absenteeism values}
}
\description{
Compiles and processes epidemic data, simulating  school absenteeism
using epidemic and individual data.
}
\examples{
# Assuming you have previously simulated epidemic and individual data:
epidemic <- ssir(1000, alpha = 0.4)
individual_data <- data.frame(elem_child_ind = sample(0:1, 1000, replace = TRUE),
                              schoolID = sample(1:10, 1000, replace = TRUE))

compiled_data <- compile_epi(epidemic, individual_data)
}
