% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-plot.R
\name{anopa_asn_trans1}
\alias{anopa_asn_trans1}
\alias{anopaPlot}
\title{anopaPlot: Easy plotting of proportions.}
\usage{
anopaPlot(w, formula, confidenceLevel = .95, allowImputing = FALSE,
		showPlotOnly = TRUE, plotStyle = "line", 
     errorbarParams  = list( width =0.5, linewidth=0.75 ), ...)
}
\arguments{
\item{w}{An ANOPA object obtained with \code{anopa()};}

\item{formula}{(optional) Use formula to plot just specific terms of the omnibus test.
For example, if your analysis stored in \code{w} has factors A, B and C, then
\code{anopaPlot(w, ~ A * B)} will only plot the factors A and B.}

\item{confidenceLevel}{Provide the confidence level for the confidence intervals
(default is 0.95, i.e., 95\%).}

\item{allowImputing}{(default FALSE) if there are cells with no observations, can they be
imputed? If imputed, the option "ANOPA.zeros" will be used to determine
how many additional observations to add, and with how many successes.
If for example, the option is (by default) \code{c(0.05, 1)}, then
20 cases will be added, only one being a success (respecting the .05 target).
\emph{Keep in mind that imputations has never been studies with regards to proportions
so be mindfull that the default optin has never been tested nor validated.}}

\item{showPlotOnly}{(optional, default True) shows only the plot or else
shows the numbers needed to make the plot yourself.}

\item{plotStyle}{(optional; default "line") How to plot the proportions;
see superb for other layouts (e.g., "line").}

\item{errorbarParams}{(optional; default list( width =0.5, linewidth=0.75 ) ) is
a list of attributes used to plot the error bars. See superb for more.}

\item{...}{Other directives sent to superb(), typically 'plotStyle',
'errorbarParams', etc.}
}
\value{
a ggplot2 object of the given proportions.
}
\description{
The function 'anopaPlot()' performs a plot of proportions for designs
with up to 4 factors according to the
'ANOPA' framework. See \insertCite{lc23;textual}{ANOPA} for more. The plot is
realized using the 'suberb' library; see \insertCite{cgh21;textual}{ANOPA}.
It uses the arc-sine transformation 'A()'.
}
\details{
The plot shows the proportions on the vertical axis as a
function of the factors (the first on the horizontal axis, the second
if any in a legend; and if a third or even a fourth factors are present,
as distinct rows and columns). It also shows 95\% confidence intervals of
the proportions, adjusted for between-cells comparisons.
The confidence intervals are based on a z distribution, which is adequate
for large samples \insertCite{c90,ll90}{ANOPA}. This "stand-alone" confidence
interval is then adjusted for between-cell comparisons using the \emph{superb}
framework \insertCite{cgh21}{ANOPA}.

See the vignette \href{../articles/B-DataFormatsForProportions.html}{\code{DataFormatsForProportions}}
for more on data formats and how to write their formula.
See the vignette \href{../articles/C-ConfidenceIntervals.html}{\code{ConfidenceIntervals}} for
details on the adjustment and its purpose.
}
\examples{
# 
# The Arrington Et Al., 2002, data on fishes' stomach
ArringtonEtAl2002

# This examine the omnibus analysis, that is, a 3 x 2 x 4 ANOPA:
w <- anopa( {s;n} ~ Location * Trophism * Diel, ArringtonEtAl2002) 

# Once processed into w, we can ask for a standard plot
anopaPlot(w)

# As you may notice, there are points missing because the data have
# three missing cells. The litterature is not clear what should be 
# done with missing cells. In this package, we propose to impute
# the missing cells based on the option `getOption("ANOPA.zeros")`.
# Consider this option with care.  
anopaPlot(w, allowImputing = TRUE)

# We can place the factor `Diel` on the x-axis (first):
\donttest{anopaPlot(w, ~ Diel * Trophism * Location )}

# Change the style for a plot with bars instead of lines
\donttest{anopaPlot(w, plotStyle = "bar")}

# Changing the error bar style
\donttest{anopaPlot(w, plotStyle = "bar", errorbarParams = list( width =0.1, linewidth=0.1 ) )}

# Illustrating the main effect of Location (not interacting with other factors)
# and the interaction Diel * Trophism separately
\donttest{anopaPlot(w, ~ Location ) }
\donttest{anopaPlot(w, ~ Diel * Trophism ) }

# All these plots are ggplot2 so they can be followed with additional directives, e.g.
library(ggplot2)
anopaPlot(w, ~ Location) + ylim(0.0, 1.0) + theme_classic()
anopaPlot(w, ~ Diel * Trophism) + ylim(0.0, 1.0) + theme_classic()

# etc. Any ggplot2 directive can be added to customize the plot to your liking.
# See the vignette `ArringtonExample`.


}
\references{
\insertAllCited{}
}
