% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq}
\alias{freq}
\alias{frequency_tbl}
\title{Frequency table}
\usage{
freq(x, sort.count = TRUE, nmax = 15, na.rm = TRUE, markdown = FALSE,
  toConsole = TRUE, digits = 2, sep = " ")

frequency_tbl(x, sort.count = TRUE, nmax = 15, na.rm = TRUE,
  markdown = FALSE, toConsole = TRUE, digits = 2, sep = " ")
}
\arguments{
\item{x}{data}

\item{sort.count}{Sort on count. Use \code{FALSE} to sort alphabetically on item.}

\item{nmax}{number of row to print. Use \code{nmax = 0} or \code{nmax = NA} to print all rows.}

\item{na.rm}{a logical value indicating whether NA values should be removed from the frequency table. The header will always print the amount of\code{NA}s.}

\item{markdown}{print table in markdown format (this forces \code{nmax = NA})}

\item{toConsole}{Print table to the console. Use \code{FALSE} to assign the table to an object.}

\item{digits}{how many significant digits are to be used for numeric values (not for the items themselves, that depends on \code{\link{getOption}("digits")})}

\item{sep}{a character string to separate the terms when selecting multiple columns}
}
\description{
Create a frequency table of a vector of data, a single column or a maximum of 9 columns of a data frame. Supports markdown for reports.
}
\details{
For numeric values, the next values will be calculated and shown into the header:
\itemize{
  \item{Mean, using \code{\link[base]{mean}}}
  \item{Standard deviation, using \code{\link[stats]{sd}}}
  \item{Five numbers of Tukey (min, Q1, median, Q3, max), using \code{\link[stats]{fivenum}}}
  \item{Outliers (count and list), using \code{\link{boxplot.stats}}}
  \item{Coefficient of variation (CV), the standard deviation divided by the mean}
  \item{Coefficient of quartile variation (CQV, sometimes called coefficient of dispersion), calculated as \code{(Q3 - Q1) / (Q3 + Q1)} using \code{\link{quantile}} with \code{type = 6} as quantile algorithm to comply with SPSS standards}
}
}
\examples{
library(dplyr)

freq(septic_patients$hospital_id)

septic_patients \%>\%
  filter(hospital_id == "A") \%>\%
  select(bactid) \%>\%
  freq()

# select multiple columns; they will be pasted together
septic_patients \%>\%
  left_join_microorganisms \%>\%
  filter(hospital_id == "A") \%>\%
  select(genus, species) \%>\%
  freq()

# save frequency table to an object
years <- septic_patients \%>\%
  mutate(year = format(date, "\%Y")) \%>\%
  select(year) \%>\%
  freq(toConsole = FALSE)
}
\keyword{freq}
\keyword{frequency}
\keyword{summarise}
\keyword{summary}
