% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_limits.R
\name{rate_limits_per_minute}
\alias{rate_limits_per_minute}
\title{Find updated rate limits for API models}
\usage{
rate_limits_per_minute(
  model = "gpt-4o-mini",
  AI_tool = "gpt",
  api_key = get_api_key()
)
}
\arguments{
\item{model}{Character string with the name of the completion model.
Default is \code{"gpt-4o-mini"}. Can take multiple values.
Find available model at
\url{https://platform.openai.com/docs/models/model-endpoint-compatibility}.}

\item{AI_tool}{Character string specifying the AI tool from which the API is
issued. Default is \code{"gpt"}.}

\item{api_key}{Numerical value with your personal API key. Default setting draws
on the \code{\link[=get_api_key]{get_api_key()}} to retrieve the API key from the R environment, so that the key is not
compromised. The API key can be added to the R environment via \code{\link[=set_api_key]{set_api_key()}}
or by using \code{\link[usethis:edit]{usethis::edit_r_environ()}}. In the \code{.Renviron} file, write \code{CHATGPT_KEY=INSERT_YOUR_KEY_HERE}.
After entering the API key, close and save the \code{.Renviron} file and restart \code{RStudio} (ctrl + shift + F10).
Alternatively, one can use \code{\link[httr2:secrets]{httr2::secret_make_key()}}, \code{\link[httr2:secrets]{httr2::secret_encrypt()}}, and
\code{\link[httr2:secrets]{httr2::secret_decrypt()}} to scramble and decrypt the API key.}
}
\value{
A \code{tibble} including variables with information about the model used,
the number of requests and tokens per minute.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}\if{html}{\out{<br>}}
\if{html}{\out{<br>}}
\code{rate_limits_per_minute} reports the rate limits for a given API model.
The function returns the available requests per minute (RPM) as well as tokens per minute (TPM).
Find general information at
\url{https://platform.openai.com/docs/guides/rate-limits/overview}.
}
\examples{
\dontrun{
set_api_key()

rate_limits_per_minute()
}
}
