% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{log_lik_grad}
\alias{log_lik_grad}
\title{Gradient of log likelihood}
\usage{
log_lik_grad(
  param,
  I_q_cur,
  B_cur,
  index_q,
  I_o_q_2_ori,
  d_input,
  q_ori_ring_loc_unique_index,
  sz,
  len_t,
  q,
  model_name,
  msd_fn = NA,
  msd_grad_fn = NA
)
}
\arguments{
\item{param}{a vector of natural logarithm of parameters}

\item{I_q_cur}{Fourier transformed intensity profile}

\item{B_cur}{current value of B. This parameter is determined by the noise
in the system. See 'References'.}

\item{index_q}{selected index of wave number}

\item{I_o_q_2_ori}{absolute square of Fourier transformed intensity profile,
ensemble over time}

\item{d_input}{sequence of lag times}

\item{q_ori_ring_loc_unique_index}{index for wave vector that give unique frequency}

\item{sz}{frame size of the intensity profile}

\item{len_t}{number of time steps}

\item{q}{wave vector in unit of um^-1}

\item{model_name}{stochastic process for constructing MSD, options from ('BM',
'OU','FBM','OU+FBM', 'user_defined')}

\item{msd_fn}{user defined mean squared displacement structure (MSD), a
function of \code{param} parameters and \code{d_input} lag times}

\item{msd_grad_fn}{user defined MSD gradient structure,  a function of
\code{param} and \code{d_input}}
}
\value{
The numerical value of gradient for natural logarithm of the likelihood.
}
\description{
This function computes the gradient for natural logarithm of the likelihood
for selected range of wave vectors. See 'References'.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
